#!/usr/bin/env python3
import os
import sys
import time
import json
import threading
import pyqrcode
from pathlib import Path
from waitress import serve

from config import LANGUAGE, _t
from app import app, refresh_systems, SYSTEMS

import views_main
import views_linux

RNDIS_LOG = Path("/tmp/liab_rndis.json")
FIRST_REQUEST_SEEN = False

def try_print_qr_from_rndis():
    if not RNDIS_LOG.exists():
        return False
    try:
        data = json.loads(RNDIS_LOG.read_text(errors="ignore"))
        url = data.get("url")
        if not url:
            return False
        qr = pyqrcode.create(url)
        print(qr.terminal(quiet_zone=1), file=sys.stderr)
        print(f"URL: {url}\n", file=sys.stderr)
        return True
    except Exception as e:
        print(f"RNDIS QR error: {e}", file=sys.stderr)
        return False


def wait_for_rndis_and_print_qr():
    printed = False
    while not printed:
        printed = try_print_qr_from_rndis()
        time.sleep(1)


if __name__ == "__main__":
    t = threading.Thread(target=wait_for_rndis_and_print_qr, daemon=True)
    t.start()

    if os.geteuid() != 0:
        print(_t['run_as_root'])
        sys.exit(1)

    refresh_systems()
    #app.run(host="0.0.0.0", port=5000, debug=False)

    serve(app, host="0.0.0.0", port=5000)
